// ---------------------------------------------------------------
//
// 4D Plugin API
//
// File : 4DPluginAPI_dll.h
//
// rev : v12.0
//
// ---------------------------------------------------------------

#ifndef __4DPLUGINAPI__
#define __4DPLUGINAPI__

#include "Flags.h"
#include "PublicTypes.h"

#if VERSIONWIN // PM: added DLL export define
  #define DLL __declspec(dllexport)
#else
  #define DLL
#endif

#ifdef __cplusplus
extern "C" {
#endif



// ---------------------------------------------------------------
// interface that must be provided by user
// ---------------------------------------------------------------
DLL void PluginMain( long selector, PA_PluginParameters params );


// ---------------------------------------------------------------
// Returns the last error returned by any call to the API
// ---------------------------------------------------------------

DLL PA_ErrorCode PA_GetLastError();


// ---------------------------------------------------------------
// After a call to PA_UseVirtualStructure(), all pending calls to
// the API will use the virtual structure references if supported.
// Use PA_UseRealStructure() to switch back to real structure.
// By default, real structure is used.
// ---------------------------------------------------------------

// reads or set 4D Plugin API internal flag
DLL void PA_UseVirtualStructure      ();
DLL void PA_UseRealStructure         ();

// asks 4D to know if a virtual structure is defined
DLL char  PA_VirtualStructureDefined ( );
DLL short PA_GetTrueTableNumber      ( short virtualTable );
DLL void  PA_GetTrueFieldNumber      ( short virtualTable, short virtualField, short* trueTable, short* trueField );
DLL short PA_GetVirtualTableNumber   ( short trueTable );
DLL void  PA_GetVirtualFieldNumber   ( short trueTable, short trueField, short* virtualTable, short* virtualField );


// ---------------------------------------------------------------
// These functions are used to manage 4D Application handle.
// they are used internally by 4D Plugin API.
// On Macintosh, you can use these handles as regular Mac handles.
// ---------------------------------------------------------------

DLL PA_Handle	PA_NewHandle		( long len );
DLL void		PA_DisposeHandle	( PA_Handle handle );
DLL long		PA_GetHandleSize	( PA_Handle handle );
DLL char		PA_SetHandleSize	( PA_Handle handle, long newlen );
DLL char*		PA_LockHandle		( PA_Handle handle );
DLL void		PA_UnlockHandle		( PA_Handle handle );
DLL void		PA_MoveBlock		( void *source, void *dest, long len );
DLL char		PA_GetHandleState	( PA_Handle handle );
DLL void		PA_SetHandleState	( PA_Handle handle, char state );

// ---------------------------------------------------------------
// strings manipulations
// ---------------------------------------------------------------

DLL PA_Unichar*		PA_GetUnistring( PA_Unistring* ustr );
DLL long			PA_GetUnistringLength( PA_Unistring* ustr );
DLL PA_Unistring	PA_CreateUnistring( PA_Unichar* ustr );
DLL void			PA_DisposeUnistring( PA_Unistring* ustr );
DLL void			PA_SetUnistring( PA_Unistring* ustr, PA_Unichar* str );
DLL char			PA_CompareUniBuffers( PA_Unichar* text1, long len1, PA_Unichar* text2, long len2, char diacritic, char useWildChar );
DLL char			PA_CompareUnichars( PA_Unichar* string1, PA_Unichar* string2, char diacritic, char useWildChar );
DLL char			PA_CompareUnistrings( PA_Unistring* ustr1, PA_Unistring* ustr2, char diacritic, char useWildChar );
DLL long			PA_GetUnicharsLength( PA_Unichar* str );
DLL void			PA_CopyUnichars( PA_Unichar* source, PA_Unichar* dest, long maxbytesize );


// ---------------------------------------------------------------
// pictures manipulations
// ---------------------------------------------------------------

DLL PA_Picture   PA_CreatePicture( void* buffer, long len );
DLL void*        PA_CreateNativePictureForScreen( PA_Picture picture );	// creates a CGImageRef on Mac, and a gdiplus::bitmap* on Windows
DLL void*        PA_CreateNativePictureForPrinting( PA_Picture picture );	// creates a CGPDFDocumentRef on Mac, and a gdiplus::metafile* on Windows
DLL void         PA_DisposePicture( PA_Picture picture );
DLL PA_Unistring PA_GetPictureData( PA_Picture picture, long index, PA_Handle handle );
DLL PA_Picture   PA_DuplicatePicture( PA_Picture picture, char retainOnly );

// ---------------------------------------------------------------
// these commands returns or set informations
// on 4D Application
// ---------------------------------------------------------------

DLL unsigned long PA_Get4DVersion ();
DLL char PA_IsDemoVersion         ();
DLL char PA_IsDatabaseLocked      ();	// may happen when running on CD-ROM
DLL char PA_IsCompiled            ( char hostDatabase);	// pass hostDatabase to 0 to ask about calling database, 1 to ask about host database.

DLL char PA_Is4DClient ();
DLL char PA_Is4DServer ();
DLL char PA_Is4DMono   ();

DLL char PA_IsWebProcess ();

DLL char PA_GetMessagesStatus  ( );
DLL void PA_SetMessagesStatus  ( char showMessages );
DLL void PA_SetThermometerRect ( PA_Rect rect );

DLL void PA_GetStructureName   ( PA_Unichar* structName );
DLL void PA_GetDataName        ( PA_Unichar* dataName );

DLL PA_Unistring PA_GetApplicationFullPath();
DLL PA_Unistring PA_GetStructureFullPath();

DLL short PA_FindPackage ( short packageID );
DLL void  PA_PackageInfo ( short packageNumber, short* packageID, void** procPtr, void** data, short* resfile, PA_Unichar* name );

DLL void  PA_Quit4D();

DLL PA_Unistring	PA_Get4DPreferencesFilePath ();
DLL PA_Unistring	PA_Get4Dfolder ( PA_FolderKind folderKind, char createIfNotFound );

DLL PA_PlatformInterface PA_GetPlatformInterface();

DLL void PA_GetToolBarInfo  ( char* displayed, short* toolbarHeight );
DLL void PA_ShowHideToolBar ( char displayed );

DLL char PA_GetTipsEnabled  ( );
DLL void PA_SetTipsEnabled  ( char enabled );

DLL long PA_CheckFreeStack  ( long requestedStack );

DLL void* PA_Get4DHInstance();

DLL void PA_GetCenturyInfo( long* pivotYear, long* defaultCentury );

// ---------------------------------------------------------------
// those commands can format strings, numbers, date and time
// as the String command in 4D. FormatNumber are the same as
// in 4D for formating date and times
// (see String command documentation)
// ---------------------------------------------------------------

DLL void PA_FormatString   ( PA_Unichar* string, PA_Unichar* format, PA_Unichar* result );
DLL void PA_FormatReal     ( double value, PA_Unichar* format, PA_Unichar* result );
DLL void PA_FormatLongint  ( long value,   PA_Unichar* format, PA_Unichar* result );
DLL void PA_FormatDate     ( short day, short month, short year, short formatNumber, PA_Unichar* result );
DLL void PA_FormatTime     ( long time, short formatNumber, PA_Unichar* result );


DLL long   PA_EvalLongint  ( PA_Unichar* string );
DLL double PA_EvalReal     ( PA_Unichar* string );
DLL void   PA_EvalDate     ( PA_Unichar* string, short* day, short* month, short* year );
DLL long   PA_EvalTime     ( PA_Unichar* string );

DLL void PA_ConvertStrings ( char* string1, PA_StringKind kind1, PA_CharSet charset1,
					     char* string2, PA_StringKind kind2, PA_CharSet charset2 );

DLL long PA_ConvertCharsetToCharset ( char* fromString, long fromSize, PA_4DCharSet fromCharset,
								 char* toString, long toSize, PA_4DCharSet toCharset);

// ---------------------------------------------------------------
// some functions needs to know if you want automatic relations to be activated.
// Default is both automatic relations On.
// calling this function tells explicitly 4D if you want automatic relations activated or not.
// ---------------------------------------------------------------

DLL void PA_UseAutomaticRelations ( char manyToOne, char oneToMany );

// ---------------------------------------------------------------
// inforation about import/export filters.
// ---------------------------------------------------------------

DLL char* PA_GetExportFilter ();
DLL char* PA_GetImportFilter ();

// ---------------------------------------------------------------
// Selection
// Warning : these functions do not use virtual structure.
// they can use automatic relations depending
// of the use of PA_UseAutomaticRelations().
// ---------------------------------------------------------------

DLL long PA_SelectedRecordNumber ( short table );
DLL void PA_GotoSelectedRecord   ( short table, long record );
DLL long PA_RecordsInSelection   ( short table );
DLL void PA_DeleteSelection      ( short table );
DLL void PA_FirstRecord          ( short table );
DLL void PA_NextRecord           ( short table );
DLL void PA_PreviousRecord       ( short table );
DLL char PA_BeforeSelection      ( short table );
DLL char PA_EndSelection         ( short table );

// ---------------------------------------------------------------
// Tables, fields, indexes & relations
// This command allows you to create tables, fields, indexes and/or
// relations using an xml definition.
// ---------------------------------------------------------------

DLL void PA_CreateElementsFromXMLDefinition( PA_Unistring* xmlDefinition);

// ---------------------------------------------------------------
// Records
// ---------------------------------------------------------------

DLL void PA_CreateRecord ( short table );
DLL void PA_SaveRecord   ( short table );
DLL void PA_GotoRecord   ( short table, long record );
DLL long PA_RecordNumber ( short table );


// ---------------------------------------------------------------
// Relations
// ---------------------------------------------------------------

DLL void PA_RelateOne  ( short table );
DLL void PA_RelateMany ( short table );
DLL void PA_RelateOneSelection  ( short manyTable, short oneTable  );
DLL void PA_RelateManySelection ( short manyTable, short manyField );


// ---------------------------------------------------------------
// Records locking
// ---------------------------------------------------------------

DLL char PA_Locked     ( short table );
DLL void PA_ReadWrite  ( short table );
DLL void PA_ReadOnly   ( short table );
DLL void PA_LoadRecord ( short table );


// ---------------------------------------------------------------
// Named selections
// ---------------------------------------------------------------

DLL void PA_CopyNamedSelection  ( short table, PA_Unichar* name );
DLL void PA_CutNamedSelection   ( short table, PA_Unichar* name );
DLL void PA_UseNamedSelection   ( PA_Unichar* name );
DLL void PA_ClearNamedSelection ( PA_Unichar* name );


// ---------------------------------------------------------------
// Sets
// ---------------------------------------------------------------

DLL void PA_CreateEmptySet ( short table, PA_Unichar* name );
DLL void PA_CreateSet	   ( short table, PA_Unichar* name );
DLL void PA_AddToSet       ( short table, PA_Unichar* name );
DLL void PA_UseSet         ( PA_Unichar* name );
DLL void PA_DeleteSet      ( PA_Unichar* name );


// ---------------------------------------------------------------
// database informations
// ---------------------------------------------------------------

// ---- tables
DLL short PA_CountTables    ( );
DLL void  PA_GetTableName   ( short table, PA_Unichar* tableName );
DLL char  PA_IsTableVisible ( short table );

//	tableAndFieldNames should be as "[Table1]field1"
DLL void  PA_GetTableAndFieldNumbers( PA_Unichar* tableAndFieldNames, short* table, short* field );

// ---- fields
DLL short PA_CountFields        ( short table );
DLL void  PA_GetFieldName       ( short table, short field, PA_Unichar* fieldName );
DLL void  PA_GetFieldProperties ( short table, short field, PA_FieldKind* kind,
                              short* stringlength, char* indexed, long* attributes );
DLL void  PA_GetFieldRelation   ( short table, short field,
                              short* relatedTable, short* relatedField );
DLL void  PA_GetFieldList       ( short table, short field, PA_Unichar* listName );

DLL void PA_TableAndFieldPopup  ( short x, short y, short* table, short* field );
DLL void PA_FieldPopup          ( short x, short y, short table, short* field );


// ---------------------------------------------------------------
// Order by
// ---------------------------------------------------------------

// easy function used to order selection using only one field, located in the table
DLL void PA_OrderBy ( short table, short field, char ascending );

// set of functions used to order selection using multiple fields
DLL PA_OrderByRef PA_OpenOrderBy ( short table );
DLL void PA_AddFieldToOrderBy ( PA_OrderByRef orderby, short table, short field, char ascending );
DLL void PA_CloseOrderBy      ( PA_OrderByRef orderby );



// ---------------------------------------------------------------
// Query
// ---------------------------------------------------------------

// set of functions used to query in selection using multiple criterias

DLL PA_QueryRef PA_OpenQuery ( short table );
DLL void PA_QueryString   ( PA_QueryRef query, short table, short field, PA_QueryOperator qo, PA_QueryComparison qc, PA_Unichar* string );
DLL void PA_QueryReal     ( PA_QueryRef query, short table, short field, PA_QueryOperator qo, PA_QueryComparison qc, double value );
DLL void PA_QueryTime     ( PA_QueryRef query, short table, short field, PA_QueryOperator qo, PA_QueryComparison qc, long value );
DLL void PA_QueryDate     ( PA_QueryRef query, short table, short field, PA_QueryOperator qo, PA_QueryComparison qc, short day, short month, short year );
DLL void PA_QueryLongint  ( PA_QueryRef query, short table, short field, PA_QueryOperator qo, PA_QueryComparison qc, long value );
DLL void PA_QueryInteger  ( PA_QueryRef query, short table, short field, PA_QueryOperator qo, PA_QueryComparison qc, short value );
DLL void PA_QueryBoolean  ( PA_QueryRef query, short table, short field, PA_QueryOperator qo, PA_QueryComparison qc, char value );
DLL void PA_CloseQuery    ( PA_QueryRef query );



// ---------------------------------------------------------------
// Get fields from database
// ---------------------------------------------------------------

DLL PA_Unistring PA_GetStringField     ( short table, short field );
DLL long         PA_GetBlobField       ( short table, short field, void* blob );
DLL PA_Handle    PA_GetBlobHandleField ( short table, short field );
DLL PA_Picture   PA_GetPictureField    ( short table, short field );
DLL double       PA_GetRealField       ( short table, short field );
DLL long         PA_GetLongintField    ( short table, short field );
DLL short        PA_GetIntegerField    ( short table, short field );
DLL long         PA_GetTimeField       ( short table, short field );
DLL void         PA_GetDateField       ( short table, short field, short* day, short* month, short* year );
DLL char         PA_GetBooleanField    ( short table, short field );

// ---------------------------------------------------------------
// Set fields in database
// ---------------------------------------------------------------

DLL void PA_SetStringField     ( short table, short field, PA_Unistring* ustr );
DLL void PA_SetBlobField       ( short table, short field, void* blob, long len );
DLL void PA_SetBlobHandleField ( short table, short field, PA_Handle hblob );
DLL void PA_SetPictureField    ( short table, short field, PA_Picture picture );
DLL void PA_SetRealField       ( short table, short field, double value );
DLL void PA_SetLongintField    ( short table, short field, long  value );
DLL void PA_SetIntegerField    ( short table, short field, short value );
DLL void PA_SetTimeField       ( short table, short field, long  value );
DLL void PA_SetDateField       ( short table, short field, short day, short month, short year );
DLL void PA_SetBooleanField    ( short table, short field, char value );



// -----------------------------------------
// 4D Application Packed Records
// -----------------------------------------

DLL long PA_GetPackedRecord ( short table, void* buffer );
DLL void PA_SetPackedRecord ( short table, void* buffer, long len );



// -----------------------------------------------------
// Read parameters when 4D Application calls
// a plugin command
// NOTE: the first parameter starts at index 1
// -----------------------------------------------------

DLL short			PA_GetShortParameter         ( PA_PluginParameters params, short index );
DLL long			PA_GetLongParameter          ( PA_PluginParameters params, short index );
DLL double			PA_GetDoubleParameter        ( PA_PluginParameters params, short index );
DLL PA_Unistring*	PA_GetStringParameter        ( PA_PluginParameters params, short index );
DLL long			PA_GetBlobParameter          ( PA_PluginParameters params, short index, void* blob );
DLL PA_Handle		PA_GetBlobHandleParameter    ( PA_PluginParameters params, short index );
DLL PA_Picture		PA_GetPictureParameter       ( PA_PluginParameters params, short index );
DLL void			PA_GetDateParameter          ( PA_PluginParameters params, short index, short* day, short* month, short* year );
DLL long			PA_GetTimeParameter          ( PA_PluginParameters params, short index );
DLL PA_Variable		PA_GetVariableParameter      ( PA_PluginParameters params, short index );


DLL PA_Pointer		PA_GetPointerParameter       ( PA_PluginParameters params, short index );

DLL PA_Variable		PA_GetPointerValue           ( PA_Pointer pointer ); // Call PA_ClearVariable to clear the returned PA_Variable.
DLL PA_PointerKind	PA_GetPointerKind			 ( PA_Pointer pointer );
DLL void			PA_GetPointerValueProperties ( PA_Pointer inPointer, PA_VariableKind* outKind, long* outStringLength, long* outArraySize);
DLL void			PA_SetPointerValue           ( PA_Pointer pointer, PA_Variable variable );
/*
DLL void			PA_SetPointerValue2           ( PA_Pointer *pointer, PA_Variable *variable );
DLL void			PA_SetPointerValue3           ( PA_Pointer pointer, PA_Variable *variable );
*/

// -----------------------------------------
// Return value when 4D Application calls
// a plugin command
// -----------------------------------------

DLL void PA_ReturnShort    ( PA_PluginParameters params, short value );
DLL void PA_ReturnLong     ( PA_PluginParameters params, long value );
DLL void PA_ReturnDouble   ( PA_PluginParameters params, double value );
DLL void PA_ReturnString   ( PA_PluginParameters params, PA_Unichar* string );
DLL void PA_ReturnBlob     ( PA_PluginParameters params, void* blob, long len );
DLL void PA_ReturnPicture  ( PA_PluginParameters params, PA_Picture picture );
DLL void PA_ReturnDate     ( PA_PluginParameters params, short day, short month, short year );
DLL void PA_ReturnTime     ( PA_PluginParameters params, long value );

DLL void PA_ReturnBlobHandle    ( PA_PluginParameters params, PA_Handle hblob );


// -----------------------------------------------------
// Set parameters when 4D Application calls
// a plugin command
// NOTE: the first parameter starts at index 1
// -----------------------------------------------------

DLL void PA_SetShortParameter	   ( PA_PluginParameters params, short index, short value );
DLL void PA_SetLongParameter	   ( PA_PluginParameters params, short index, long value );
DLL void PA_SetDoubleParameter     ( PA_PluginParameters params, short index, double value );
DLL void PA_SetBlobParameter	   ( PA_PluginParameters params, short index, void* blob, long len );
DLL void PA_SetBlobHandleParameter ( PA_PluginParameters params, short index, PA_Handle hblob );
DLL void PA_SetPictureParameter	   ( PA_PluginParameters params, short index, PA_Picture picture );
DLL void PA_SetDateParameter	   ( PA_PluginParameters params, short index, short day, short month, short year );
DLL void PA_SetTimeParameter	   ( PA_PluginParameters params, short index, long value );
DLL void PA_SetVariableParameter   ( PA_PluginParameters params, short index, PA_Variable variable, char clearOldValue );



// -----------------------------------------------------
// manage events on a plugin area
// -----------------------------------------------------

DLL PA_AreaEvent	PA_GetAreaEvent   ( PA_PluginParameters params );
DLL PA_Rect			PA_GetAreaRect    ( PA_PluginParameters params );
DLL PA_Unistring*   PA_GetAreaName    ( PA_PluginParameters params );
DLL void    PA_GetPluginProperties    ( PA_PluginParameters params, PA_PluginProperties* properties );
DLL void    PA_SetAreaReference       ( PA_PluginParameters params, void* ref );
DLL void*   PA_GetAreaReference       ( PA_PluginParameters params );
DLL void    PA_SetAreaFocusable       ( PA_PluginParameters params, char focusable );
DLL char    PA_IsActivated            ( PA_PluginParameters params );
DLL char    PA_IsDeActivated          ( PA_PluginParameters params );
DLL void    PA_AcceptSelect           ( PA_PluginParameters params, char accept );
DLL void    PA_AcceptDeselect         ( PA_PluginParameters params, char accept );
DLL void    PA_GetClick               ( PA_PluginParameters params, short* x, short* y );
DLL short	PA_GetMouseWheelIncrement ( PA_PluginParameters params );
DLL char    PA_GetKey                 ( PA_PluginParameters params, PA_Unichar* unichar, PA_KeyCode* keycode, char* altKey, char* ctrlKey, char* shiftKey );
DLL void    PA_CustomizeDesignMode    ( PA_PluginParameters params );
DLL void    PA_DontTakeEvent          ( PA_PluginParameters params );
DLL void    PA_CallPluginAreaMethod   ( PA_PluginParameters params );
DLL void    PA_SetMenuIcon            ( PA_PluginParameters params, short id );
DLL long    PA_GetUpdateHDC           ( );
DLL void	PA_PublishWebPicture      ( PA_PluginParameters params, char pictureMap );
DLL void	PA_SendHTML               ( PA_PluginParameters params, void* webData, char* HTMLbuffer, long len );
DLL void	PA_SendWebPicture         ( PA_PluginParameters params, void* webData, void* picture, long len, PA_WebPictureKind kind );
DLL void*	PA_GetWebDataToDispose    ( PA_PluginParameters params );
DLL void	PA_GotoNextField          ( PA_PluginParameters params );
DLL void	PA_GotoPreviousField      ( PA_PluginParameters params );
DLL void	PA_GetPageChange          ( PA_PluginParameters params, short *pageFrom, short *pageTo );
DLL void	PA_RequestRedraw          ( PA_PluginParameters params );


// -----------------------------------------------------
// manage dropping events on a plugin area
// -----------------------------------------------------

DLL PA_DragAndDropInfo	PA_GetDragAndDropInfo		( PA_PluginParameters params );
DLL void				PA_AllowDrop				( PA_PluginParameters params, char allow );
DLL void				PA_GetDragPositions			( PA_PluginParameters params, PA_Rect* rect, short* x, short* y );
DLL void				PA_CustomizeDragOver		( PA_PluginParameters params );
DLL PA_DragContextRef	PA_GetDragAndDropContext	( PA_PluginParameters params );


// -----------------------------------------------------
// Getting informations on a Drag And Drop Info structure
// -----------------------------------------------------

DLL PA_DragKind PA_GetDragAndDropKind     ( PA_DragAndDropInfo info );
DLL PA_Variable PA_GetDragAndDropVariable ( PA_DragAndDropInfo info, long* indice );
DLL void PA_GetDragAndDropTableField      ( PA_DragAndDropInfo info, short* table, short* field );


// -----------------------------------------------------
// Initiate a drag and drop
// to be called on a eAE_MouseDown event
// -----------------------------------------------------

DLL void PA_DragAndDrop( short startX, short startY, char useCustomRect, PA_Rect customRect );


// -----------------------------------------------------
// manage the drag and drop context
// -----------------------------------------------------
DLL PA_PasteboardRef PA_GetDragAndDropPasteboard ( PA_DragContextRef context );


// -----------------------------------------------------
// manage the pasteboard
// -----------------------------------------------------

DLL char			PA_IsPasteboardDataAvailable	( PA_PasteboardRef pasteboard, PA_Unichar *kind );
DLL PA_Handle		PA_GetPasteboardData			( PA_PasteboardRef pasteboard, PA_Unichar *kind );
DLL unsigned long	PA_GetPasteboardDataSize		( PA_PasteboardRef pasteboard, PA_Unichar *kind );
DLL char			PA_SetPasteboardData			( PA_PasteboardRef pasteboard, PA_Unichar *kind, void *data, unsigned long size );


// -----------------------------------------------------
// Advanced Properties of a plugin area
// -----------------------------------------------------

DLL void  PA_SetAdvancedPropertiesEditable  ( PA_PluginParameters params, char editable );
DLL void  PA_SetAdvancedProperties          ( PA_PluginParameters params, void* data, long datasize );
DLL void* PA_GetAdvancedPropertiesToDispose ( PA_PluginParameters params );
DLL void* PA_GetAdvancedProperties          ( PA_PluginProperties* properties, long* datasize );



// ---------------------------------------------------------------
// Get 4D Application variables
// ---------------------------------------------------------------

DLL PA_Variable	PA_CreateVariable          ( PA_VariableKind kind );
DLL PA_Variable	PA_GetVariable             ( PA_Unichar* variableName );
DLL PA_VariableKind PA_GetVariableKind     ( PA_Variable variable );
DLL PA_VariableKind PA_GetPointerValueKind ( PA_Pointer inVarPtr );

DLL PA_Unistring PA_GetStringVariable      ( PA_Variable variable );
DLL long         PA_GetBlobVariable        ( PA_Variable variable, void* blob );
DLL PA_Handle    PA_GetBlobHandleVariable  ( PA_Variable variable );
DLL PA_Picture   PA_GetPictureVariable     ( PA_Variable variable );
DLL double       PA_GetRealVariable        ( PA_Variable variable );
DLL long         PA_GetLongintVariable     ( PA_Variable variable );
DLL long         PA_GetTimeVariable        ( PA_Variable variable );
DLL void         PA_GetDateVariable        ( PA_Variable variable, short* day, short* month, short* year );
DLL char         PA_GetBooleanVariable     ( PA_Variable variable );




// ---------------------------------------------------------------
// Set 4D Application variables
// ---------------------------------------------------------------

DLL void PA_SetVariable ( PA_Unichar* variableName, PA_Variable variable, char clearOldValue );

DLL void PA_SetStringVariable     ( PA_Variable* variable, PA_Unistring* ustr );
DLL void PA_SetBlobVariable       ( PA_Variable* variable, void* blob, long len );
DLL void PA_SetBlobHandleVariable ( PA_Variable* variable, PA_Handle hblob );
DLL void PA_SetPictureVariable    ( PA_Variable* variable, PA_Picture picture );
DLL void PA_SetRealVariable       ( PA_Variable* variable, double value );
DLL void PA_SetLongintVariable    ( PA_Variable* variable, long value   );
DLL void PA_SetTimeVariable       ( PA_Variable* variable, long value   );
DLL void PA_SetDateVariable       ( PA_Variable* variable, short day, short month, short year );
DLL void PA_SetBooleanVariable    ( PA_Variable* variable, char value );

// those functions are usefull to pass parameters to 4D Commands, using PA_ExecuteCommandByID
DLL void PA_SetOperationVariable   ( PA_Variable* variable, char op );		// op can be '*', '<', '>'...
DLL void PA_SetTableFieldVariable ( PA_Variable* variable, short table, short field );	// pass 0 to table to pass only the field
DLL void PA_SetVariableOrFieldReference ( PA_Variable* outVariable , PA_Pointer inPointer);  // Passes a reference to 4D like a parameter& in c++ or an object in java. No need of PA_ClearVariable or PA_SetPointerValue when using a reference

// ---------------------------------------------------------------
// CleanUp of a 4D Application variable
// ---------------------------------------------------------------

DLL void PA_ClearVariable( PA_Variable* variable );

// ---------------------------------------------------------------
// 4D Application arrays
// ---------------------------------------------------------------

// general functions on arrays
DLL long  PA_GetArrayNbElements ( PA_Variable ar );
DLL void  PA_ResizeArray        ( PA_Variable* ar, long nb );

DLL long  PA_GetArrayCurrent    ( PA_Variable ar );
DLL void  PA_SetArrayCurrent    ( PA_Variable* ar, long current );

// Reading values on arrays
DLL short        PA_GetIntegerInArray ( PA_Variable ar, long i );
DLL long         PA_GetLongintInArray ( PA_Variable ar, long i );
DLL double       PA_GetRealInArray    ( PA_Variable ar, long i );
DLL void         PA_GetDateInArray    ( PA_Variable ar, long i, short* day, short* month, short* year );
DLL PA_Picture   PA_GetPictureInArray ( PA_Variable ar, long i );
DLL PA_Unistring PA_GetStringInArray  ( PA_Variable ar, long i );
DLL char         PA_GetBooleanInArray ( PA_Variable ar, long i );
DLL PA_Variable  PA_GetArrayInArray   ( PA_Variable ar, long i );
DLL PointerBlock PA_GetPointerInArray ( PA_Variable ar, long i );

// Setting values on arrays
DLL void PA_SetIntegerInArray   ( PA_Variable ar, long i, short value );
DLL void PA_SetLongintInArray   ( PA_Variable ar, long i, long value  );
DLL void PA_SetRealInArray      ( PA_Variable ar, long i, double value );
DLL void PA_SetDateInArray      ( PA_Variable ar, long i, short day, short month, short year );
DLL void PA_SetStringInArray    ( PA_Variable ar, long i, PA_Unistring* ustr );
DLL void PA_SetPictureInArray   ( PA_Variable ar, long i, PA_Picture picture );
DLL void PA_SetBooleanInArray   ( PA_Variable ar, long i, char value );
DLL void PA_SetArrayInArray     ( PA_Variable ar, long i, PA_Variable value );
DLL void PA_SetPointerInArray   ( PA_Variable ar, long i, PointerBlock value );

// ---------------------------------------------------------------
// 4D Application Methods and functions
// ---------------------------------------------------------------


DLL void			PA_CreateMethod    (PA_Unichar* methodName, PA_MethodFlags ref, PA_Unistring* methodCode, PA_Unichar* folderName );
DLL void			PA_ModifyMethod    (PA_Unichar* methodName, PA_Unistring* methodCode );
DLL void			PA_ExecuteMethod   ( PA_Unistring* ustr );
DLL PA_Variable		PA_ExecuteFunction ( PA_Unistring* ustr );

DLL long			PA_Tokenize                ( PA_Unistring* ustr, void* tokens );
DLL PA_Unistring	PA_Detokenize              ( void* tokens, long len );
DLL void			PA_ByteSwapTokens          ( void* tokens, long len );
DLL void			PA_ExecuteTokens           ( void* tokens, long len );
DLL PA_Variable		PA_ExecuteTokensAsFunction ( void* tokens, long len );

DLL long			PA_GetMethodID             ( PA_Unichar* methodName );
DLL PA_Variable		PA_ExecuteMethodByID       ( long id, PA_Variable* parameters, short nbParameters );

DLL long			PA_GetCommandID			   ( PA_Unichar* commandName );
DLL PA_Variable		PA_ExecuteCommandByID      ( long id, PA_Variable* parameters, short nbParameters );

// use same index as the "command name" 4D command.
DLL void			PA_GetCommandName          ( long index, PA_Unichar* commandName );

// ---------------------------------------------------------------
// localisation
// ---------------------------------------------------------------

DLL PA_Unistring PA_LocaliseStringByID( long resID, long resIndex, char pluginResource );
DLL PA_Unistring PA_LocaliseString( PA_Unichar* name, char pluginResource );

// ---------------------------------------------------------------
// Log and Backup operations
// ---------------------------------------------------------------

DLL void PA_LockDatabase( );
DLL void PA_UnlockDatabase( );

// ---------------------------------------------------------------
// Multiprocess Printing Management
// ---------------------------------------------------------------

DLL char PA_TryToOpenPrinterSession();
DLL char PA_OpenPrinterSession();
DLL void PA_ClosePrinterSession();
DLL void* PA_GetCarbonPrintSettings();
DLL void* PA_GetCarbonPageFormat();
DLL void* PA_GetWindowsPRINTDLG();
DLL void* PA_GetWindowsPrintingDC();


// ---------------------------------------------------------------
// Processes
// ---------------------------------------------------------------

DLL long PA_CountActiveProcess      ( );
DLL long PA_CountTotalProcess       ( );
DLL void PA_GetProcessInfo          ( long process, PA_Unichar* name, long* state, long* time );
DLL void PA_FreezeProcess           ( long process );
DLL void PA_UnfreezeProcess         ( long process );
DLL char PA_IsProcessDying          ( );
DLL void PA_KillProcess             ( );
DLL void PA_PutProcessToSleep       ( long process, long time );
DLL long PA_GetCurrentProcessNumber ( );
DLL long PA_GetWindowProcess        ( PA_WindowRef windowRef );
DLL long PA_GetFrontWindowProcess   ( char withPalette );
DLL void PA_SetWindowProcess        ( PA_WindowRef windowRef, long process );
DLL void PA_Yield                   ( );
DLL void PA_YieldAbsolute           ( );
DLL char PA_WaitNextEvent		    ( PA_Event* event );
DLL void PA_UpdateProcessVariable   ( long process );
DLL void PA_BringProcessToFront     ( long process );
DLL long PA_NewProcess				( void* procPtr, long stackSize, PA_Unichar* name );
DLL void PA_PostMacEvent            ( long process, PA_Event* event );

// Execute some C code in Main Process. Function should be declared as void myFunc(void*)
// It may be mandatory for some API call on MacOSX like calling system dialogs
DLL void PA_RunInMainProcess        ( PA_RunInMainProcessProcPtr procPtr, void* parameters );

// ---------------------------------------------------------------
// Sending/Receiving documents on 4D Client from 4D Server
// ---------------------------------------------------------------

DLL long PA_ReceiveDocumentFromServer ( PA_Unichar* docName, void* buffer );
DLL void PA_SendDocumentToServer      ( PA_Unichar* docName, void* buffer, long len, unsigned long type, unsigned long creator );
DLL char PA_DocumentExistOnServer     ( PA_Unichar* docName, unsigned long type, unsigned long creator );



// ---------------------------------------------------------------
// Sending/Receiving data between 4D Client and 4D Server
// ---------------------------------------------------------------

DLL void PA_SendDataToServer      ( long pluginRef, long dataRef, long dataKind, void* buffer, long len );
DLL long PA_ReceiveDataFromServer ( long pluginRef, long dataRef, long dataKind, void* buffer );



// ---------------------------------------------------------------
// 4D Application internal resource manager used by 4D structure
// ---------------------------------------------------------------

// To read a resource, read first the length of the resource by passing a null buffer to PA_GetResource
// then allocate a buffer of the proper size, and finally read it in the buffer calling PA_GetResource again.
// Before manipulating a resource, you need to lock it over the network so no one can modify it
// during the time you read or modify it.

DLL long  PA_CreateResource                 ( short resfile, unsigned long kind, long id, PA_Unichar* name, char* data, long len );
DLL void  PA_RemoveResourceByID             ( short resfile, unsigned long kind, long id );
DLL void  PA_RemoveResourceByName           ( short resfile, unsigned long kind, PA_Unichar* name );
DLL long  PA_GetResource                    ( short resfile, unsigned long kind, long id, char* data );
DLL void  PA_SetResource                    ( short resfile, unsigned long kind, long id, char* data, long len );
DLL char  PA_LockResource                   ( short resfile, unsigned long kind, long id );
DLL void  PA_UnlockResource                 ( short resfile, unsigned long kind, long id );
DLL void  PA_ReleaseResource                ( short resfile, unsigned long kind, long id );
DLL long  PA_GetIndexedResource             ( short resfile, unsigned long kind, long index, char* data );
DLL void  PA_GetResourceName                ( short resfile, unsigned long kind, long id, PA_Unichar* name );
DLL void  PA_SetResourceName                ( short resfile, unsigned long kind, long id, PA_Unichar* name );
DLL long  PA_GetResourceSize                ( short resfile, unsigned long kind, long id );
DLL long  PA_GetResourceTimeStamp           ( short resfile, unsigned long kind, long id );
DLL long  PA_GetResourceIDList              ( short resfile, unsigned long kind, long* IDlist );
DLL long  PA_GetUniqueResID                 ( short resfile, unsigned long kind );
DLL long  PA_GetResourceKindList            ( short resfile, unsigned long* kindlist );
DLL long  PA_CountResources                 ( short resfile, unsigned long kind );
DLL long  PA_CountResourceKinds             ( short resfile );
DLL short PA_OpenResFile                    ( PA_Unistring* filename );
DLL short PA_CreateResFile                  ( PA_Unistring* filename );
DLL void  PA_UpdateResFile                  ( short resfile );
DLL void  PA_UseResFile                     ( short resfile );
DLL void  PA_CloseResFile                   ( short resfile );
DLL short PA_GetDatabaseResFile             ( );
DLL PA_Handle PA_GetResourceHandle          ( short resfile, unsigned long kind, long id );
DLL void  PA_WriteResourceHandle            ( short resfile, PA_Handle handle );
DLL long  PA_CreateResourceFromHandle       ( short resfile, unsigned long kind, long id, PA_Unichar* name, PA_Handle resourceHandle );
DLL void  PA_DetachResource                 ( short resfile, PA_Handle resourceHandle );
DLL void  PA_LockResourceHandle             ( short resfile, PA_Handle resourceHandle );
DLL void  PA_UnlockResourceHandle           ( short resfile, PA_Handle resourceHandle );
DLL void  PA_ReleaseResourceHandle          ( short resfile, PA_Handle resourceHandle );
DLL unsigned long PA_GetIndexedResourceKind ( short resfile, long index );

// -----------------------------------------
//	4D Application users info
// -----------------------------------------

DLL void PA_GetUserName( PA_Unichar* name );
DLL long PA_GetCurrentUserID();

// return a string array variable that can be parsed using array commands
// array starts by Designers users, then administrators users, then regular users
DLL PA_Variable PA_GetUsersArray( long* nbDesignerUsers, long* nbAdministratorUsers );
DLL PA_Variable PA_GetGroupsArray( long* nbDesignerGroups, long* nbAdministratorGroups );


// -----------------------------------------
//	4D Application serial key and users info
// -----------------------------------------

DLL long PA_GetSerialKey             ( );
DLL void PA_GetRegisteredUserName    ( PA_Unichar *name );
DLL void PA_GetRegisteredUserCompany ( PA_Unichar *company );
DLL long PA_CountConnectedUsers      ( );
DLL long PA_GetMaxAllowedUsers       ( );



// -----------------------------------------
//	4D Application Plugin Windows
// -----------------------------------------


DLL PA_PluginRef PA_OpenPluginWindow ( PA_Unichar* areaName, PA_Unichar* windowTitle, PA_Rect rect );
DLL PA_WindowRef PA_NewWindow        ( PA_Rect rect, PA_WindowLevel level, short kind, PA_Unichar* title, char closeBox );

DLL void  PA_SetWindowFocusable    ( PA_WindowRef windowRef, char focusable );
DLL char  PA_IsWindowFocusable     ( PA_WindowRef windowRef );

DLL PA_WindowRef PA_GetWindowFocused ( );
DLL void         PA_SetWindowFocused ( PA_WindowRef windowRef );
DLL char         PA_IsWindowFocused  ( PA_WindowRef windowRef );

DLL void  PA_UpdateVariables       ( );
DLL long  PA_GetHWND               ( PA_WindowRef windowRef );
DLL long  PA_GetWindowPtr          ( PA_WindowRef windowRef );
DLL void  PA_ClosePluginWindow     ( PA_PluginRef pluginRef );
DLL void  PA_SetPluginWindowTitle  ( PA_PluginRef pluginRef, PA_Unichar* windowTitle );
DLL void  PA_SetPluginAreaClipMode ( PA_PluginRef pluginRef, char clipChildren );
DLL short PA_GetCurrentPage        ( );
DLL void  PA_CreateTip             ( PA_Unistring* ustr, char useRTF, short posX, short posY, PA_Rect rect );
DLL void  PA_GotoArea              ( PA_Unichar* variableName );
DLL void  PA_UpdateEditMenu        ( char undo, char redo, char cut, char copy, char paste, char clear, char selectAll );
DLL void  PA_CloseWindow           ( PA_WindowRef windowRef );


// -----------------------------------------
//	4D Application Text Editors
// -----------------------------------------

DLL PA_Handle PA_GetCurrentTEHandle();


// -----------------------------------------
//	4D Application Web Server
// -----------------------------------------

DLL void PA_StartWebServer   ( );
DLL void PA_StopWebServer    ( );
DLL void PA_GetWebServerInfo ( long* webServerProcess, long* TCPport );
DLL void PA_SetWebTCPport    ( long TCPport );
DLL void PA_GetWebContext    ( long* context, long* subContext, PA_Unichar* name );
DLL long PA_GetWebTimeOut    ( );
DLL void PA_SetWebTimeOut    ( long timeOut );
DLL void PA_OpenURL          ( PA_Unistring* url );


// -----------------------------------------
//	4D Application SpellCheckers
// -----------------------------------------

DLL void  PA_Install4DWriteSpeller    ( void* spellcheckerProcPtr );
DLL void* PA_Get4DWriteSpellerProcPtr ( );


// -----------------------------------------
//	4D Application Editors
// -----------------------------------------

DLL char PA_FormulaEditor      ( short defaultTable, PA_Unistring* formula );
DLL void PA_QueryDialog        ( short table );
DLL void PA_OrderByDialog      ( short table );
DLL void PA_Alert              ( PA_Unichar* message, PA_WindowRef ref );
DLL void PA_CharAlert		   ( const char* message, PA_WindowRef ref );
DLL char PA_Confirm            ( PA_Unichar* message, PA_WindowRef ref );
DLL char PA_Request            ( PA_Unichar* message, PA_Unichar* value, PA_Unichar* okButton, PA_Unichar* cancelButton );
DLL PA_Handle PA_PictureEditor ( PA_Unichar* windowTitle,  void* picture, long len );
DLL void PA_MethodEditor       ( PA_Unichar* methodName, long lineNumber );
DLL void PA_AboutDialog        ( );


// -----------------------------------------
//	4D Application Pictures
// -----------------------------------------

// Quicktime is mandatory for this routine, format needs to be a valid quicktime format
DLL PA_Handle PA_ConvertPicture( void* picture, long len, unsigned long format );

// returns a EMF handle
DLL void* PA_PictureToEMF ( void* picture, long len );

DLL PA_Handle PA_PictureToGIF  ( void* picture, long len );


// -----------------------------------------
//	4D Application Dialogs
// -----------------------------------------

// dialog
DLL PA_Dial4D   PA_NewDialog           ( );
DLL PA_Dial4D   PA_OpenDialog          ( PA_Dial4D dialog, PA_Unichar* dialogName, PA_Unichar* windowTitle, char closeBox );
DLL char PA_ModalDialog                ( PA_Dial4D dialog, PA_Unichar* variableName );
DLL void PA_CloseDialog                ( PA_Dial4D dialog );
DLL void PA_Dial4DCancelValidate       ( PA_Dial4D dialog, char cancel );
DLL void PA_Dial4DDisposeEmptyDialog   ( PA_Dial4D dialog );

// variables
DLL long         PA_Dial4DGetLong      ( PA_Dial4D dialog, PA_Unichar* variableName );
DLL double       PA_Dial4DGetReal      ( PA_Dial4D dialog, PA_Unichar* variableName );
DLL void         PA_Dial4DGetDate      ( PA_Dial4D dialog, PA_Unichar* variableName, short* day, short* month, short* year );
DLL long         PA_Dial4DGetTime      ( PA_Dial4D dialog, PA_Unichar* variableName );
DLL void         PA_Dial4DGetString    ( PA_Dial4D dialog, PA_Unichar* variableName, PA_Unichar* string );
DLL PA_Unistring PA_Dial4DGetText      ( PA_Dial4D dialog, PA_Unichar* variableName );
DLL PA_Variable  PA_Dial4DGetVariable  ( PA_Dial4D dialog, PA_Unichar* variableName );

DLL void PA_Dial4DSetLong              ( PA_Dial4D dialog, PA_Unichar* variableName, long value );
DLL void PA_Dial4DSetReal              ( PA_Dial4D dialog, PA_Unichar* variableName, double value );
DLL void PA_Dial4DSetDate              ( PA_Dial4D dialog, PA_Unichar* variableName, short day, short month, short year );
DLL void PA_Dial4DSetTime              ( PA_Dial4D dialog, PA_Unichar* variableName, long time );
DLL void PA_Dial4DSetString            ( PA_Dial4D dialog, PA_Unichar* variableName, PA_Unichar* string );
DLL void PA_Dial4DSetText              ( PA_Dial4D dialog, PA_Unichar* variableName, PA_Unistring* text );
DLL void PA_Dial4DSetPicture           ( PA_Dial4D dialog, PA_Unichar* variableName, PA_Picture picture );
DLL void PA_Dial4DSetVariable          ( PA_Dial4D dialog, PA_Unichar* variableName, PA_Variable var );

// arrays
DLL void PA_Dial4DNewArrayLong         ( PA_Dial4D dialog, PA_Unichar* variableName );
DLL void PA_Dial4DNewArrayReal         ( PA_Dial4D dialog, PA_Unichar* variableName );
DLL void PA_Dial4DNewArrayString       ( PA_Dial4D dialog, PA_Unichar* variableName );
DLL void PA_Dial4DNewArrayPicture      ( PA_Dial4D dialog, PA_Unichar* variableName );
DLL void PA_Dial4DNewArrayText         ( PA_Dial4D dialog, PA_Unichar* variableName );

DLL long PA_Dial4DGetArraySize         ( PA_Dial4D dialog, PA_Unichar* variableName );
DLL void PA_Dial4DDeleteArrayElements  ( PA_Dial4D dialog, PA_Unichar* variableName, long position, long amount );

DLL void PA_Dial4DSetArrayTextFromResource      ( PA_Dial4D dialog, PA_Unichar* variableName, short resourceID );
DLL void PA_Dial4DSetArrayTextFromTableList     ( PA_Dial4D dialog, PA_Unichar* variableName );
DLL void PA_Dial4DSetArrayTextFromFieldList     ( PA_Dial4D dialog, PA_Unichar* variableName, short table );
DLL void PA_Dial4DSetArrayTextFromTTR           ( PA_Dial4D dialog, PA_Unichar* variableName, PA_Unistring* ustr );
DLL void PA_Dial4DSetArrayPictureFromResources  ( PA_Dial4D dialog, PA_Unichar* variableName, short* idArray, long nb );

DLL void PA_Dial4DSetArrayLong           ( PA_Dial4D dialog, PA_Unichar* variableName, long value, long position );
DLL void PA_Dial4DSetArrayReal           ( PA_Dial4D dialog, PA_Unichar* variableName, double value, long position );
DLL void PA_Dial4DSetArrayText           ( PA_Dial4D dialog, PA_Unichar* variableName, PA_Unistring* text, long position );
DLL void PA_Dial4DSetArrayString         ( PA_Dial4D dialog, PA_Unichar* variableName, PA_Unichar*   string, long position );
DLL void PA_Dial4DSetArrayPicture        ( PA_Dial4D dialog, PA_Unichar* variableName, PA_Picture picture, long position );

DLL long         PA_Dial4DGetArrayLong   ( PA_Dial4D dialog, PA_Unichar* variableName, long indice );
DLL double       PA_Dial4DGetArrayReal   ( PA_Dial4D dialog, PA_Unichar* variableName, long indice );
DLL PA_Unistring PA_Dial4DGetArrayText   ( PA_Dial4D dialog, PA_Unichar* variableName, long indice );
DLL void         PA_Dial4DGetArrayString ( PA_Dial4D dialog, PA_Unichar* variableName, PA_Unichar* string, long indice );

DLL long PA_Dial4DFindArrayLong          ( PA_Dial4D dialog, PA_Unichar* variableName, long value,   long startPosition );
DLL long PA_Dial4DFindArrayReal          ( PA_Dial4D dialog, PA_Unichar* variableName, double value, long startPosition );

// context switch from process variables to dialog variables
DLL void* PA_Dial4DSaveVariables         ( PA_Dial4D dialog );
DLL void  PA_Dial4DRestoreVariables      ( PA_Dial4D dialog, void* env );

// update modified variables in dialog
DLL void  PA_Dial4DBeginUpdateVariables  ( PA_Dial4D dialog );
DLL void  PA_Dial4DEndUpdateVariables    ( PA_Dial4D dialog );

// external areas
DLL void  PA_Dial4DSetAreaHandler        ( PA_Dial4D dialog, PA_Unichar* variableName, void* handler, void* privateData );
DLL void  PA_Dial4DRedrawExternalArea    ( PA_Dial4D dialog, PA_Unichar* variableName );

// user datas
DLL void  PA_Dial4DSetUserData           ( PA_Dial4D dialog, void* userData );
DLL void* PA_Dial4DGetUserData           ( PA_Dial4D dialog );

// pages
DLL void  PA_Dial4DGotoPage              ( PA_Dial4D dialog, short page );
DLL short PA_Dial4DGetCurrentPage        ( PA_Dial4D dialog );

// objects
DLL void  PA_Dial4DGetVariableRect       ( PA_Dial4D dialog, PA_Unichar* variableName, PA_Rect* rect );
DLL void  PA_Dial4DSetVariableRect       ( PA_Dial4D dialog, PA_Unichar* variableName, PA_Rect rect );
DLL void  PA_Dial4DShowHideVariable      ( PA_Dial4D dialog, PA_Unichar* variableName, char visible );
DLL void  PA_Dial4DShowHideObject        ( PA_Dial4D dialog, PA_Unichar* objectName,   char visible );
DLL void  PA_Dial4DSetEnterable          ( PA_Dial4D dialog, PA_Unichar* variableName, char enterable );
DLL void  PA_Dial4DSetEnable             ( PA_Dial4D dialog, PA_Unichar* variableName, char enabled );
DLL void  PA_Dial4DSetMin                ( PA_Dial4D dialog, PA_Unichar* variableName, double minValue );
DLL void  PA_Dial4DSetMinDate            ( PA_Dial4D dialog, PA_Unichar* variableName, short day, short month, short year );
DLL void  PA_Dial4DSetMax                ( PA_Dial4D dialog, PA_Unichar* variableName, double maxValue );
DLL void  PA_Dial4DSetMaxDate            ( PA_Dial4D dialog, PA_Unichar* variableName, short day, short month, short year );
DLL void  PA_Dial4DSet3StatesCheckBox    ( PA_Dial4D dialog, PA_Unichar* variableName, char state );
DLL void  PA_Dial4DSetEntryFilter        ( PA_Dial4D dialog, PA_Unichar* variableName, PA_Unichar* entryFilter );
DLL void  PA_Dial4DSetDisplayFormat      ( PA_Dial4D dialog, PA_Unichar* variableName, PA_Unichar* displayFormat );
DLL void  PA_Dial4DSetObjectTitle        ( PA_Dial4D dialog, PA_Unichar* objectName,   PA_Unichar* title );
DLL void  PA_Dial4DUpdateObjectTitle     ( PA_Dial4D dialog, PA_Unichar* variableName );
DLL void  PA_Dial4DGetLastObject         ( PA_Dial4D dialog, PA_Unichar* objectName   );
DLL void  PA_Dial4DGotoVariable          ( PA_Dial4D dialog, PA_Unichar* variableName );
DLL void  PA_Dial4DHighlightText         ( PA_Dial4D dialog, PA_Unichar* variableName, short startSelection, short endSelection );

// hlists
DLL void  PA_Dial4DNewTableFieldHList          ( PA_Dial4D dialog, PA_Unichar* variableName, short table, char showRelatedTables, char showRelatedFields, char useIcons, char sorted );
DLL void  PA_Dial4DGetTableFieldHListCurrent   ( PA_Dial4D dialog, PA_Unichar* variableName, short* table, short* field );
DLL void  PA_Dial4DSetTableFieldHListCurrent   ( PA_Dial4D dialog, PA_Unichar* variableName, short table, short field );
DLL void  PA_Dial4DDisposeHList                ( PA_Dial4D dialog, PA_Unichar* variableName );

// drag and drop
DLL void  PA_Dial4DGetDragInfo                 ( PA_Dial4D dialog, PA_Unichar* dropVariable, short* dropX, short* dropY, PA_Dial4D* dragDialog, PA_Unichar* dragVariable, short* dragX, short* dragY );

// windows
DLL PA_Dial4D    PA_Dial4DDial4DFromWindow     ( PA_WindowRef window );
DLL PA_WindowRef PA_Dial4DWindowFromDial4D     ( PA_Dial4D dialog );
DLL void         PA_Dial4DAllowXResize         ( PA_Dial4D dialog, char allowResize );
DLL void         PA_Dial4DAllowYResize         ( PA_Dial4D dialog, char allowResize );
DLL void         PA_Dial4DGetWindowMinMaxInfo  ( PA_Dial4D dialog, long* minXresize, long* maxXresize, long* minYresize, long* maxYresize );
DLL void         PA_Dial4DSetWindowSize        ( PA_Dial4D dialog, long width, long height );

#ifdef __cplusplus
}
#endif

#endif
